﻿if (typeof MCS == "undefined")
{ MCS = {}; }
// Create Namespace container for functions in this library;

if (typeof MCS.FacilityApproval == "undefined") {
    MCS.FacilityApproval = {};
}

MCS.FacilityApproval.Statuspatientsc = -1;
MCS.FacilityApproval.Statuspatientcos = -1;
MCS.FacilityApproval.Statusprovidersc = -1;
MCS.FacilityApproval.Statusprovidercos = -1;

MCS.FacilityApproval.OnLoad = function () {
    MCS.FacilityApproval.OnlyProviderHM();

    //Check for Hub Approval
    if (Xrm.Page.getAttribute("cvt_hubfacility").getValue() != null) {
        Xrm.Page.ui.tabs.get("tab_hub").setVisible(true);
        Xrm.Page.ui.tabs.get("tab_pat").setVisible(false);
        Xrm.Page.ui.tabs.get("tab_pro").setVisible(false);
    }
    else {
        Xrm.Page.ui.tabs.get("tab_hub").setVisible(false);
        Xrm.Page.ui.tabs.get("tab_pat").setVisible(true);
        Xrm.Page.ui.tabs.get("tab_pro").setVisible(true);
    }
    if (Xrm.Page.ui.getFormType() != 1) {

        Xrm.Page.getControl("cvt_resourcepackage").setDisabled(true);
        Xrm.Page.getControl("cvt_patientfacility").setDisabled(true);
        Xrm.Page.getControl("cvt_providerfacility").setDisabled(true);
    }

    MCS.FacilityApproval.Statuspatientsc = Xrm.Page.getAttribute("cvt_approvalstatuspatientsc") != null ? Xrm.Page.getAttribute("cvt_approvalstatuspatientsc").getValue() : -1;
    MCS.FacilityApproval.Statuspatientcos = Xrm.Page.getAttribute("cvt_approvalstatuspatientcos") != null ? Xrm.Page.getAttribute("cvt_approvalstatuspatientcos").getValue() : -1;
    MCS.FacilityApproval.Statusprovidersc = Xrm.Page.getAttribute("cvt_approvalstatusprovidersc") != null ? Xrm.Page.getAttribute("cvt_approvalstatusprovidersc").getValue() : -1;
    MCS.FacilityApproval.Statusprovidercos = Xrm.Page.getAttribute("cvt_approvalstatusprovidercos") != null ? Xrm.Page.getAttribute("cvt_approvalstatusprovidercos").getValue() : -1;

    //Check Status Reason of the record, and if it is Approved or Denied, then display a message at the top
    if (Xrm.Page.getAttribute("cvt_automaticallyapproved").getValue() != null && Xrm.Page.getAttribute("cvt_automaticallyapproved").getValue() == true)
        MCS.cvt_Common.Notifications("Add", 3, "This interfacility TSA was automatically approved by the system during the transition to the Scheduling Package structure.");
};


MCS.FacilityApproval.CreateName = function () {
    var derivedResultField = "";

    var patFacility = Xrm.Page.getAttribute("cvt_patientfacility").getValue();
    var proFacility = Xrm.Page.getAttribute("cvt_providerfacility").getValue();

    var patFacilityName = "";
    var proFacilityName = "";

    if (patFacility != null)
        patFacilityName = "-> " + patFacility[0].name;

    if (proFacility != null)
        proFacilityName = proFacility[0].name;


    derivedResultField = proFacilityName + " " + patFacilityName;

    if (Xrm.Page.getAttribute("cvt_name").getValue() != derivedResultField) {
        Xrm.Page.getAttribute("cvt_name").setSubmitMode("always");
        Xrm.Page.getAttribute("cvt_name").setValue(derivedResultField);
    }
};

MCS.FacilityApproval.OnlyProviderHM = function () {
    //Make the SOS field visible and get the url
    if (Xrm.Page.getAttribute("cvt_resourcepackage").getValue() != null) {
        var calls = CrmRestKit.Retrieve("cvt_resourcepackage", Xrm.Page.getAttribute("cvt_resourcepackage").getValue()[0].id, ['cvt_patientlocationtype'], false);
        calls.fail(
                function (error) {
                }).done(function (data) {
                    if (data && data.d && data.d.cvt_patientlocationtype != null) {
                        if (data.d.cvt_patientlocationtype.Value == 917290001) {
                            //Hide Patient Facility Approval information and fields
                            MCS.cvt_Common.Notifications("Add", 3, "Only Provider Facility Approval possible for a VA Video Connect Resource Package.");
                            Xrm.Page.getAttribute("cvt_patientfacility").setRequiredLevel("none");
                            Xrm.Page.getAttribute("cvt_patientfacility").setValue();
                            Xrm.Page.getControl("cvt_patientfacility").setDisabled(true);

                            //Also hide Patient Facility Approvals section
                            Xrm.Page.ui.tabs.get('tab_General').sections.get('tab_General_section_Patient').setVisible(false);
                        }
                    }
                });
    }
    else {
        //clear out Facility field
        //save
        if (Xrm.Page.getAttribute("cvt_facility").getValue() != null) {
            Xrm.Page.getAttribute("cvt_facility").setValue(null);
        }
    }
};

//approvalSide = patient or provider
//teamType = cos or sc

//approvalSide = hub
//teamType = director
MCS.FacilityApproval.Sign = function (exObj, approvalSide, teamType) {
    //verify that the current user is on the team that is being updated
    var currentUserId = Xrm.Page.context.getUserId();
    var team = null;
    if (approvalSide == "hub") {
        team = Xrm.Page.getAttribute("cvt_hubdirectorteam").getValue();
    }
    else {
        var fullTeamType = teamType == "cos" ? "chiefofstaff" : "servicechief";
        team = Xrm.Page.getAttribute("cvt_" + fullTeamType + "team" + approvalSide).getValue();
    }

    var approvalStatus = Xrm.Page.getAttribute("cvt_approvalstatus" + approvalSide + teamType);
    var isSysAdmin = MCS.cvt_Common.userHasRoleInList("System Administrator");

    //Find team members for that team and see if currentUser is on that team.
    var filter = "SystemUserId eq (Guid' " + currentUserId + "') and TeamId eq (Guid' " + team[0].id + "')";
    //Query for any team membership records where the team ID equals the team listed and the userId of logged in user matches the TeamMemberShip UserId
    var query = CrmRestKit.ByQuery("TeamMembership", ['TeamId'], filter, false);
    query.fail(function (err) {
        
    }).done(function (data) {
        if (data && data.d.results) {
            if (data.d.results.length > 0 || isSysAdmin) {
                if (approvalStatus != null)
                {
                    var userObj = new Array();
                    userObj[0] = new Object();
                    userObj[0].id = currentUserId;
                    userObj[0].name = Xrm.Page.context.getUserName();
                    userObj[0].entityType = 'SystemUser';

                    var dateObj = Date.now();

                    //Can change the status
                    switch (approvalStatus.getValue()) {
                        case 917290001: //approved
                        case 917290002: //denied
                            //Check for all other fields
                            break;
                        case 917290000: //pending
                        default:
                            //clear out fields
                            userObj = null;
                            dateObj = null
                            break;
                    }
                    var signeeField = Xrm.Page.getAttribute("cvt_signee" + approvalSide + teamType);
                    var dateSignedField = Xrm.Page.getAttribute("cvt_datesigned" + approvalSide + teamType);

                    signeeField.setValue(userObj);
                    dateSignedField.setValue(dateObj);

                    signeeField.setSubmitMode("always");
                    dateSignedField.setSubmitMode("always");

                    if (isSysAdmin)
                        alert("You can change this approval status because you are a System Administrator.");
                }
            }
            else {
                alert("You are not on the correct team to change this approval status.");
                approvalStatus.setValue(MCS.FacilityApproval["Status" + approvalSide + teamType]);
            }
        }
    });
};